# 機能設計書 55-Awareness Health

## 概要

本ドキュメントは、OpenSearchにおけるAwareness Health機能の設計を記述する。Awareness Healthは、ゾーン・ラック等のアウェアネス属性に基づいてクラスタのヘルス状態を監視する機能である。

### 本機能の処理概要

Awareness Health機能は、クラスタヘルスAPIの拡張として、アウェアネス属性（ゾーン、ラック等）ごとのヘルス情報を提供する。各属性値ごとのノード数、シャード統計、重み情報を集約して返却する。

**業務上の目的・背景**：マルチゾーン構成のOpenSearchクラスタにおいて、ゾーンごとのヘルス状態を把握することは運用上重要である。特定のゾーンでの障害や負荷集中を早期に検知するために、アウェアネス属性単位でのヘルス監視が必要となる。

**機能の利用シーン**：
- マルチゾーンクラスタのゾーンごとのヘルス状態確認
- ゾーン障害時の影響範囲の把握
- 重み付きルーティング設定後の各ゾーンの状態確認
- 容量計画のためのゾーンごとのリソース使用状況確認

**主要な処理内容**：
1. クラスタヘルスAPIへのlevel=awareness_attributesパラメータ追加
2. アウェアネス属性ごとのノード集計
3. 属性値ごとのシャード統計（active/initializing/relocating/unassigned）集計
4. 重み情報の付加

**関連システム・外部連携**：ClusterHealthActionと連携してヘルス情報を取得する。WeightedRoutingMetadataと連携して重み情報を取得する。

**権限による制御**：`cluster:monitor/health`アクション権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | クラスタヘルス | 主画面 | ヘルス情報の取得 |

## 機能種別

監視 / クラスタ管理

## 入力仕様

### REST API
- エンドポイント: `GET /_cluster/health`
- アクション名: `cluster:monitor/health`

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| level | String | No | 詳細レベル | cluster/indices/shards/awareness_attributes |
| awareness_attribute | String | No | 対象のアウェアネス属性名 | level=awareness_attributesの場合は必須 |
| timeout | TimeValue | No | タイムアウト | デフォルト30秒 |
| wait_for_status | String | No | 待機するステータス | green/yellow/red |
| wait_for_no_relocating_shards | boolean | No | リロケーション完了待ち | - |
| wait_for_no_initializing_shards | boolean | No | 初期化完了待ち | - |
| wait_for_active_shards | String | No | アクティブシャード数待ち | - |
| wait_for_nodes | String | No | ノード数待ち | - |

### 入力データソース

- ClusterState
- WeightedRoutingMetadata

## 出力仕様

### 出力データ（level=awareness_attributes時）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cluster_name | String | クラスタ名 |
| status | String | クラスタステータス（green/yellow/red） |
| awareness_attributes | Object | アウェアネス属性ごとのヘルス情報 |

#### awareness_attributes.{attribute_name}

| 項目名 | 型 | 説明 |
|--------|-----|------|
| {attribute_value} | Object | 属性値ごとのヘルス情報 |

#### awareness_attributes.{attribute_name}.{attribute_value}

| 項目名 | 型 | 説明 |
|--------|-----|------|
| active_shards | int | アクティブシャード数 |
| initializing_shards | int | 初期化中シャード数 |
| relocating_shards | int | リロケーション中シャード数 |
| unassigned_shards | int | 未割り当てシャード数 |
| data_nodes | int | データノード数 |
| weight | double | 設定された重み |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. クラスタヘルスリクエスト受信
   └─ level=awareness_attributesパラメータ確認
2. パラメータバリデーション
   └─ awareness_attributeパラメータの必須チェック
3. ClusterAwarenessHealth生成
   └─ ClusterStateとClusterSettingsから情報収集
4. 属性ごとの集計
   └─ ClusterAwarenessAttributesHealth生成
5. 属性値ごとの集計
   └─ ClusterAwarenessAttributeValueHealth生成
6. レスポンス返却
   └─ JSON形式で返却
```

### フローチャート

```mermaid
flowchart TD
    A[クラスタヘルスリクエスト] --> B{level判定}
    B -->|awareness_attributes| C{awareness_attribute指定?}
    B -->|その他| D[通常のヘルス処理]

    C -->|なし| ERR[バリデーションエラー]
    C -->|あり| E[ClusterAwarenessHealth生成]

    E --> F[データノード取得]
    F --> G[属性値ごとにノードをグループ化]
    G --> H[シャード統計集計]
    H --> I[重み情報取得]
    I --> J[ClusterAwarenessAttributeValueHealth生成]
    J --> K[レスポンス返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 属性パラメータ必須 | level=awareness_attributesの場合、awareness_attributeパラメータが必須 | level=awareness_attributes時 |
| BR-02 | データノード限定 | シャード統計はデータノードのみを対象 | 常時 |
| BR-03 | 未割り当て計算 | 未割り当てシャードは特定の属性値に紐付かないため、全体で集計 | 常時 |
| BR-04 | 重み取得 | WeightedRoutingMetadataから重み情報を取得 | 重み設定時 |

### 計算ロジック

#### シャード統計集計
```
各属性値ごとに:
  active_shards = 該当ノード上のアクティブシャード数
  initializing_shards = 該当ノード上の初期化中シャード数
  relocating_shards = 該当ノードから/へのリロケーション中シャード数
  data_nodes = 該当属性値を持つデータノード数
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| ヘルス取得 | ClusterState | READ | クラスタ状態の参照 |
| ヘルス取得 | WeightedRoutingMetadata | READ | 重み情報の参照 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | IllegalArgumentException | awareness_attributeパラメータ未指定 | パラメータを指定する |
| 408 | - | タイムアウト | タイムアウト値を延長 |

### リトライ仕様

クラスタヘルスAPIは読み取り専用のため、クライアント側でリトライを実装する必要がある。

## トランザクション仕様

読み取り専用操作のため、トランザクションは使用しない。

## パフォーマンス要件

- ヘルス情報の取得はメモリ内操作のため軽量
- 大規模クラスタでもミリ秒オーダーで応答

## セキュリティ考慮事項

- `cluster:monitor/health`アクション権限が必要
- クラスタの内部情報が含まれるため、適切なアクセス制御が必要

## 備考

- ClusterHealthRequest.Level列挙型にAWARENESS_ATTRIBUTESが追加されている
- 重み情報はWeightedRoutingMetadataが設定されている場合のみ返却

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClusterAwarenessHealth.java | `server/src/main/java/org/opensearch/cluster/awarenesshealth/ClusterAwarenessHealth.java` | アウェアネスヘルスのトップレベルクラス |
| 1-2 | ClusterAwarenessAttributesHealth.java | `server/src/main/java/org/opensearch/cluster/awarenesshealth/ClusterAwarenessAttributesHealth.java` | 属性ごとのヘルス情報 |
| 1-3 | ClusterAwarenessAttributeValueHealth.java | `server/src/main/java/org/opensearch/cluster/awarenesshealth/ClusterAwarenessAttributeValueHealth.java` | 属性値ごとのヘルス詳細 |

#### Step 2: リクエスト/レスポンスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ClusterHealthRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/health/ClusterHealthRequest.java` | Level.AWARENESS_ATTRIBUTESの定義 |
| 2-2 | ClusterHealthResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/health/ClusterHealthResponse.java` | レスポンスのデータ構造 |

#### Step 3: 処理ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportClusterHealthAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/health/TransportClusterHealthAction.java` | Level.AWARENESS_ATTRIBUTESの場合の処理パス |

### プログラム呼び出し階層図

```
REST API (GET /_cluster/health?level=awareness_attributes)
    |
    +-- TransportClusterHealthAction
          |
          +-- level == AWARENESS_ATTRIBUTES判定
          |
          +-- ClusterAwarenessHealth生成
                |
                +-- ClusterState取得
                +-- ClusterSettings取得
                |
                +-- ClusterAwarenessAttributesHealth生成
                      |
                      +-- データノードフィルタリング
                      +-- 属性値ごとにグループ化
                      |
                      +-- ClusterAwarenessAttributeValueHealth生成
                            |
                            +-- シャード統計集計
                            +-- 重み情報取得
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ClusterHealthRequest -----> TransportClusterHealthAction -------> ClusterHealthResponse
 (level=awareness_attributes, |                                    (awareness_attributes{})
  awareness_attribute)         +-> ClusterAwarenessHealth
                               |     +-> ClusterState参照
                               |     +-> WeightedRoutingMetadata参照
                               |
                               +-> ClusterAwarenessAttributesHealth
                               |     +-> ノードグループ化
                               |
                               +-> ClusterAwarenessAttributeValueHealth
                                     +-> シャード統計計算
                                     +-> 重み取得
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ClusterAwarenessHealth.java | `server/src/main/java/org/opensearch/cluster/awarenesshealth/ClusterAwarenessHealth.java` | ソース | トップレベルヘルスクラス |
| ClusterAwarenessAttributesHealth.java | `server/src/main/java/org/opensearch/cluster/awarenesshealth/ClusterAwarenessAttributesHealth.java` | ソース | 属性ごとのヘルス |
| ClusterAwarenessAttributeValueHealth.java | `server/src/main/java/org/opensearch/cluster/awarenesshealth/ClusterAwarenessAttributeValueHealth.java` | ソース | 属性値ごとのヘルス |
| ClusterHealthRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/health/ClusterHealthRequest.java` | ソース | リクエストデータ構造 |
| ClusterHealthResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/health/ClusterHealthResponse.java` | ソース | レスポンスデータ構造 |
| TransportClusterHealthAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/health/TransportClusterHealthAction.java` | ソース | メイン処理ロジック |
